<?php

namespace App\Exports\SuperAdmin;

use Maatwebsite\Excel\Concerns\FromArray;
use Maatwebsite\Excel\Concerns\WithHeadings;

class TherapistsExport implements FromArray, WithHeadings
{
    /**
     * @return \Illuminate\Support\Collection
     */
    protected $therapists;
    public function __construct($therapists)
    {
        $this->therapists = $therapists;
    }
    public function array(): array
    {
        $data = [];
        foreach ($this->therapists as $therapist) {
            $single = [$therapist->id, $therapist->name, $therapist->description, $therapist->is_active, date_format($therapist->created_at, 'd-m-Y')];
            $data[] = $single;
        }
        return $data;
    }
    public function headings(): array
    {
        return ["id", "name", "description", "is_active", "created_at"];
    }
}
